﻿using UnityEngine;
using System.Collections.Generic;
using System.IO;
using UnityEngine.UI;
using System.Globalization;

public class Local
{
	// ------------------------------------------------------------------------------------------
	public static Dictionary<string, string> traductions = new Dictionary<string, string>();

	// ------------------------------------------------------------------------------------------
	public static string currentLanguage = null;
	private static CultureInfo currentCulture = null;
	private static List<SystemLanguage> supportedLanguages = null;
	public static List<SystemLanguage> SupportedLanguages
	{
		get
		{
			if (supportedLanguages == null)
			{
				supportedLanguages = new();

				for (SystemLanguage s = 0; s < SystemLanguage.Unknown; s++)
				{
					TextAsset txttmp = (TextAsset)Resources.Load("Local/" + s.ToString(), typeof(TextAsset));
					if (txttmp != null)
					{
						supportedLanguages.Add(s);
					}
				}
			}
			return supportedLanguages;
		}
	}
	public static CultureInfo GetCurrentCultureInfo()
	{
		currentCulture ??= CultureInfo.CurrentUICulture;
		return currentCulture;
	}

	// ------------------------------------------------------------------------------------------
	public static bool Exists(string key)
	{
		return traductions.ContainsKey(key);
	}

	// ------------------------------------------------------------------------------------------
	public void AddCalendars()
	{
		new GregorianCalendar();
		new PersianCalendar();
		new UmAlQuraCalendar();
		new ThaiBuddhistCalendar();
	}

	// ------------------------------------------------------------------------------------------
	public static string GetNb(int value, string key)
	{
		if (traductions.ContainsKey(key))
		{
			string text = traductions[key];

			if (value > 1)
			{
				return value.ToString() + " " + text + "s";
			}
			else
			{
				return value.ToString() + " " + text;
			}
		}

		Debug.LogError("trad " + key + " no exist");
		return "";
	}

	// ------------------------------------------------------------------------------------------
	public static bool Contains(string key)
	{
		return traductions.ContainsKey(key);
	}

	// ------------------------------------------------------------------------------------------
	public static string Get(string key, string value = null, string value2 = null)
	{
		if (string.IsNullOrEmpty(key))
		{
			return "";
		}

		if (traductions.ContainsKey(key))
		{
			if (value == null)
			{
				return traductions[key];
			}
			else if (value2 == null)
			{
				return traductions[key].Replace("%s", value);
			}
			else
			{
				string text = traductions[key];
				int index = text.IndexOf("%s");

				text = text.Remove(index, 2);
				text = text.Insert(index, value);

				return text.Replace("%s", value2);
			}
		}
		else
		{
#if UNITY_EDITOR
			//Debug.Log("Unknown trad '" + key + "'");
#endif
			return key.Replace("%s", value);
		}
	}

	// ------------------------------------------------------------------------------------------
	private static void Load(string language)
	{
		currentLanguage = language;

		TextAsset txt = (TextAsset)Resources.Load("Local/" + language, typeof(TextAsset));

		if (txt == null)
		{
			Debug.LogError("Language " + language + " does not exist");
			return;
		}

		StringReader sr = new StringReader(txt.text);

		string line;
		while ((line = sr.ReadLine()) != null)
		{
			if (line.Length < 1) continue;
			if (line[0] == '#') continue;

			if (line[0] == '\"')
			{
				line = line.Substring(1);

				string newLine;
				while ((newLine = sr.ReadLine()) != null)
				{
					line += "\n";
					line += newLine;
					if (newLine.Contains("\""))
					{
						break;
					}
				}
			}

			string[] expr = line.Split(new char[] { '=' }, 2);

			if (expr == null || expr.Length < 2) continue;

			if (string.IsNullOrEmpty(expr[1])) continue;

			traductions[expr[0]] = expr[1].Replace("<br>", "\n").Replace("\\n", "\n");
		}

	}

	// ------------------------------------------------------------------------------------------
	public static void Init(string forcedLanguage = null)
	{
		// Load English by default
		Load("English");

		if (string.IsNullOrEmpty(forcedLanguage))
		{
			forcedLanguage = Application.systemLanguage.ToString();
		}

		if (forcedLanguage != "English")
		{
			Load(forcedLanguage);
		}

		// --------------------------------------------------------------------------------------

		Text[] textList = UnityEngine.Object.FindObjectsOfType(typeof(Text)) as Text[];
		//Text[] textList = Resources.FindObjectsOfTypeAll(typeof(Text)) as Text[];

		//Debug.Log("Traductions en cours : " + textList.Length);

		foreach (Text text in textList)
		{
			if (text.text.Length < 2) continue;

			if (traductions.ContainsKey(text.text))
			{
				text.text = traductions[text.text];
			}
			else
			{
				string path = "";
				Transform dad = text.transform;

				while (dad != null)
				{
					path = dad.name.ToString() + "/" + path;
					dad = dad.parent;
				}

				//Debug.Log("Unknown Text.Text '" + text.text + "' (" + path +")");
			}
		}
	}

	// ------------------------------------------------------------------------------------------
}
